//
//  AFNetworkMacros.h
//  CoreNetworking
//
//  Created by Keith Duncan on 17/10/2010.
//  Copyright 2010 Keith Duncan. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <objc/objc-auto.h>

#define AFNETWORK_API_VERSION 20121007

#if defined(__cplusplus)
	#define AFNETWORK_EXTERN extern "C"
#else
	#define AFNETWORK_EXTERN extern
#endif /* defined(__cplusplus) */

#define AFNETWORK_NSSTRING_CONSTANT(var) NSString *const var = @#var

#define AFNETWORK_NSSTRING_CONTEXT(var) static NSString *var = @#var

#if !defined(__has_feature)
	#define __has_feature(x) 0
#endif

#if OBJC_NO_GC || __has_feature(objc_arc)
	#define AFNETWORK_STRONG
#else
	#define AFNETWORK_STRONG __strong
#endif /* OBJC_NO_GC */

__unused static void _AFNetworkCallScopedBlock(dispatch_block_t const *blockRef) {
	if (*blockRef != nil) (*blockRef)();
}
#define af_scoped_block_t dispatch_block_t __attribute__((cleanup(_AFNetworkCallScopedBlock), unused))
